--[[ ScreenSelectMusic decorations ]]

local t = LoadFallbackB();

t[#t+1] = StandardDecorationFromFileOptional( "BannerFrame","BannerFrame" );
t[#t+1] = StandardDecorationFromFileOptional( "StageDisplay", "StageDisplay" );
t[#t+1] = StandardDecorationFromFileOptional( "SortDisplay", "SortDisplay" );
t[#t+1] = StandardDecorationFromFile( "BPMDisplay", "BPMDisplay" );
t[#t+1] = StandardDecorationFromFile( "SongLength", "SongLength" );
t[#t+1] = StandardDecorationFromFileOptional( "AvailableDifficulties", "AvailableDifficulties" );
t[#t+1] = StandardDecorationFromFileOptional( "GrooveRadar", "GrooveRadar" );
t[#t+1] = StandardDecorationFromFileOptional( "DifficultyList", "DifficultyList" );
t[#t+1] = StandardDecorationFromFileOptional( "CourseContents", "CourseContents" );
t[#t+1] = StandardDecorationFromFileOptional( "Balloon", "Balloon" );
t[#t+1] = StandardDecorationFromFileOptional( "NumCourseSongs", "NumCourseSongs" );
t[#t+1] = StandardDecorationFromFileOptional( "CourseHasMods", "CourseHasMods" );
t[#t+1] = StandardDecorationFromFileOptional( "PaneDisplayTextP1","PaneDisplayTextP1" );
t[#t+1] = StandardDecorationFromFileOptional( "PaneDisplayTextP2","PaneDisplayTextP2" );
t[#t+1] = StandardDecorationFromFileOptional( "Statusbar","Statusbar" );
t[#t+1] = StandardDecorationFromFileOptional( "Diffnum","Diffnum" );
t[#t+1] = StandardDecorationFromFileOptional( "MachineRank", "MachineRank" );

for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
	local diffIcon = LoadActor( THEME:GetPathG( Var "LoadingScreen", "DifficultyIcon" ), pn );
	t[#t+1] = StandardDecorationFromTable( "DifficultyIcon" .. ToEnumShortString(pn), diffIcon );
end

local function StepsDisplay(pn)
	local function set(self, player)
		self:SetFromGameState( player );
	end

	local name = "StepsDisplay";

	local sd = Def.StepsDisplay {
		InitCommand=cmd(Load,name .. PlayerNumberToString(pn),GAMESTATE:GetPlayerState(pn););
		CurrentSongChangedMessageCommand=function(self)
			local SongOrCourse = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong();
			self:visible(SongOrCourse ~= nil)
		end;
	};

	if pn == PLAYER_1 then
		sd.CurrentStepsP1ChangedMessageCommand=function(self) set(self, pn); end;
		sd.CurrentTrailP1ChangedMessageCommand=function(self) set(self, pn); end;
	else
		sd.CurrentStepsP2ChangedMessageCommand=function(self) set(self, pn); end;
		sd.CurrentTrailP2ChangedMessageCommand=function(self) set(self, pn); end;
	end

	return sd;
end


local function PercentScore(pn)
	local t = Def.ActorFrame {
		LoadActor(THEME:GetPathG("MusicWheelItem","song OverPart/graph_mini"))..{
			InitCommand=cmd(zoom,0.125;x,-63;y,5);
			SetCommand=function(self)
				local SongOrCourse, StepsOrTrail;
				if GAMESTATE:IsCourseMode() then
					SongOrCourse = GAMESTATE:GetCurrentCourse();
					StepsOrTrail = GAMESTATE:GetCurrentTrail(pn);
				else
					SongOrCourse = GAMESTATE:GetCurrentSong();
					StepsOrTrail = GAMESTATE:GetCurrentSteps(pn);
				end;
				local song = GAMESTATE:GetCurrentSong();
				if PROFILEMAN:IsPersistentProfile(pn) then
					-- player profile
					profile = PROFILEMAN:GetProfile(pn);
				else
					-- machine profile
					profile = PROFILEMAN:GetMachineProfile();
				end;

				if SongOrCourse and StepsOrTrail then
					scorelist = profile:GetHighScoreList(SongOrCourse,StepsOrTrail);
					assert(scorelist);
					local scores = scorelist:GetHighScores();
					local topscore = scores[1];

					if topscore then
						local misses = topscore:GetTapNoteScore("TapNoteScore_Miss")+topscore:GetTapNoteScore("TapNoteScore_CheckpointMiss")
						local boos = topscore:GetTapNoteScore("TapNoteScore_W5")
						local goods = topscore:GetTapNoteScore("TapNoteScore_W4")
						local greats = topscore:GetTapNoteScore("TapNoteScore_W3")
						local perfects = topscore:GetTapNoteScore("TapNoteScore_W2")

						if (misses+boos+goods) == 0 then
							self:Load(THEME:GetPathG("MusicWheelItem","song OverPart/graph_mini"));
							if (greats+perfects) == 0 then
								self:diffuse(color("1,1,1,1"));
								self:x(-58);
								self:glowshift();
							elseif greats == 0 then
								self:x(-63);
								self:diffuse(color("1,0.8,0,1"));
								self:glowshift();
							else
								self:x(-64);
								self:diffuse(color("0.2,1,0.6,1"));
								self:stopeffect();
							end;
							self:diffusealpha(1);
						else
							self:diffusealpha(0);
						end
					else
						self:diffusealpha(0);
					end
				else
					self:diffusealpha(0);
				end
			end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		};

		Def.Quad{
			InitCommand=cmd(shadowlength,0;x,-72;y,9);
			BeginCommand=cmd(playcommand,"Set");
			SetCommand=function(self)
				local SongOrCourse, StepsOrTrail;
				if GAMESTATE:IsCourseMode() then
					SongOrCourse = GAMESTATE:GetCurrentCourse();
					StepsOrTrail = GAMESTATE:GetCurrentTrail(pn);
				else
					SongOrCourse = GAMESTATE:GetCurrentSong();
					StepsOrTrail = GAMESTATE:GetCurrentSteps(pn);
				end;
				local pm = GAMESTATE:GetPlayMode()
				if pm ~= "PlayMode_Oni" and pm ~= "PlayMode_Endless" then
					if SongOrCourse and StepsOrTrail then
						local st = StepsOrTrail:GetStepsType();
						local diff = StepsOrTrail:GetDifficulty();
						local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
						local cd = GetCustomDifficulty(st, diff, courseType);
						if PROFILEMAN:IsPersistentProfile(pn) then
							-- player profile
							profile = PROFILEMAN:GetProfile(pn);
						else
							-- machine profile
							profile = PROFILEMAN:GetMachineProfile();
						end;
						scorelist = profile:GetHighScoreList(SongOrCourse,StepsOrTrail);
						assert(scorelist);
						local scores = scorelist:GetHighScores();
						assert(scores);
						local topgrade;
						if scores[1] then
							topgrade = scores[1]:GetGrade();
							assert(topgrade);
							if scores[1]:GetScore()>0 then
								self:visible(true);
								self:Load(THEME:GetPathG("Panegrades/PaneGradeEval",ToEnumShortString(topgrade)));
								self:diffusealpha(1);
							else
								self:visible(false);
								self:diffusealpha(0);
							end;
						else
							self:visible(false);
							self:diffusealpha(0);
						end;
					else
						self:visible(false);
						self:diffusealpha(0);
					end;
				else
					self:visible(false);
					self:diffusealpha(0);
				end;
			end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		};
		--personal score
		LoadFont("PaneDisplay text")..{
			InitCommand=cmd(shadowlength,0;zoom,0.9;maxwidth,200;horizalign,right;zoomx,0.6;y,10);
			BeginCommand=cmd(playcommand,"Set");
			SetCommand=function(self)
				local SongOrCourse, StepsOrTrail;
				if GAMESTATE:IsCourseMode() then
					SongOrCourse = GAMESTATE:GetCurrentCourse();
					StepsOrTrail = GAMESTATE:GetCurrentTrail(pn);
				else
					SongOrCourse = GAMESTATE:GetCurrentSong();
					StepsOrTrail = GAMESTATE:GetCurrentSteps(pn);
				end;

				local profile, scorelist;
				local text = "";
				if SongOrCourse and StepsOrTrail then
					local st = StepsOrTrail:GetStepsType();
					local diff = StepsOrTrail:GetDifficulty();
					local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
					local cd = GetCustomDifficulty(st, diff, courseType);
					profile = PROFILEMAN:GetProfile(pn);

					scorelist = profile:GetHighScoreList(SongOrCourse,StepsOrTrail);
					assert(scorelist)
					local scores = scorelist:GetHighScores();
					local topscore = scores[1];
					if topscore then
						if topscore:GetPercentDP()*100.0 == 100 then
							text = "100%";
							self:zoomx(0.75);
							self:diffuse(color("0,1,1,1"));
						elseif (topscore:GetPercentDP()*100.0 >= 80.0) then
							text = string.format("%.2f%%", topscore:GetPercentDP()*100.0);
							self:zoomx(0.6);
							self:diffuse(color("0,1,1,1"));
						elseif (topscore:GetPercentDP() == 0) then
							text = "0%";
							self:zoomx(0.6);
							self:diffuse(color("0,1,1,0.75"));
						else
							text = string.format("%.2f%%", topscore:GetPercentDP()*100.0);
							self:zoomx(0.6);
							self:diffuse(color("0,0.775,0.775,1"));
						end;
					else
						text = "0%";
						self:zoomx(0.6);
						self:diffuse(color("0,1,1,0.5"));
					end;
				else
					text = "0%";
					self:zoomx(0.6);
					self:diffuse(color("0,1,1,0.5"));
				end;
				self:settext(text);
			end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		};
		--machine score
		LoadFont("PaneDisplay text")..{
			InitCommand=cmd(shadowlength,0;zoom,0.9;maxwidth,200;horizalign,right;zoomx,0.6);
			BeginCommand=cmd(playcommand,"Set");
			SetCommand=function(self)
				local SongOrCourse, StepsOrTrail;
				if GAMESTATE:IsCourseMode() then
					SongOrCourse = GAMESTATE:GetCurrentCourse();
					StepsOrTrail = GAMESTATE:GetCurrentTrail(pn);
				else
					SongOrCourse = GAMESTATE:GetCurrentSong();
					StepsOrTrail = GAMESTATE:GetCurrentSteps(pn);
				end;

				local profile, scorelist;
				local text = "";
				if SongOrCourse and StepsOrTrail then
					local st = StepsOrTrail:GetStepsType();
					local diff = StepsOrTrail:GetDifficulty();
					local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
					local cd = GetCustomDifficulty(st, diff, courseType);
					
					profile = PROFILEMAN:GetMachineProfile();

					scorelist = profile:GetHighScoreList(SongOrCourse,StepsOrTrail);
					assert(scorelist)
					local scores = scorelist:GetHighScores();
					local topscore = scores[1];
					if topscore then
						if topscore:GetPercentDP() == 1 then
							text = "100%";
							self:zoomx(0.75);
							self:diffuse(color("1,1,1,1"));
						elseif (topscore:GetPercentDP()*100.0 >= 80.0) then
							text = string.format("%.2f%%", topscore:GetPercentDP()*100.0);
							self:zoomx(0.6);
							self:diffuse(color("1,1,1,1"));
						elseif (topscore:GetPercentDP() == 0) then
							text = "0%";
							self:zoomx(0.6);
							self:diffuse(color("1,1,1,0.75"));
						else
							text = string.format("%.2f%%", topscore:GetPercentDP()*100.0);
							self:zoomx(0.6);
							self:diffuse(color("0.775,0.775,0.775,1"));
						end;
					else
						text = "0%";
						self:zoomx(0.6);
						self:diffuse(color("1,1,1,0.5"));
					end;
				else
					text = "0%";
					self:zoomx(0.6);
					self:diffuse(color("1,1,1,0.5"));
				end;
				self:settext(text);
			end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		};
	};

	if pn == PLAYER_1 then
		t.CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
		t.CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
	else
		t.CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
		t.CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
	end

	return t;
end

for pn in ivalues(PlayerNumber) do
	if ShowStandardDecoration("PercentScore"..ToEnumShortString(pn)) then
		t[#t+1] = StandardDecorationFromTable("PercentScore"..ToEnumShortString(pn), PercentScore(pn));
	end;
end

for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
	local MetricsName = "StepsDisplay" .. PlayerNumberToString(pn);
	t[#t+1] = StepsDisplay(pn) .. {
		InitCommand=function(self)
			self:player(pn);
			self:name(MetricsName);
			ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen");
		end;
	};
end

if ShowStandardDecoration("SongOptions") then
	t[#t+1] = StandardDecorationFromFileOptional("SongOptions","SongOptions") .. {
		ShowPressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsShowCommand");
		ShowEnteringOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsEnterCommand");
		HidePressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsHideCommand");
	};
end;

t[#t+1] = Def.ActorFrame{
	Name="OptionIcons";
	InitCommand=function(self)
		-- xxx: encapsulate this into a function
		self:y(SCREEN_CENTER_Y+282/2);
		self:draworder(96);
	end;

	LoadActor("OptionIconsSel", PLAYER_1)..{
		InitCommand=cmd(player,PLAYER_1;x,(SCREEN_CENTER_X*0.575)-162.5;);
		OnCommand=cmd(zoom,0.78;zoomy,0;sleep,0.5;linear,0.3;zoomy,0.78);
	};

	LoadActor("OptionIconsSel", PLAYER_2)..{
		InitCommand=cmd(player,PLAYER_2;x,(SCREEN_CENTER_X*1.425)-63;);
		OnCommand=cmd(zoom,0.78;zoomy,0;sleep,0.5;linear,0.3;zoomy,0.78);
	};
};

t[#t+1] = Def.Actor{
	Name="TheQuickerHackerUper"; -- BOUNTY
	SetCommand=function(self)
		local SongOrCourse = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong();
		if not SongOrCourse then
			-- hack time
			for pn in ivalues(PlayerNumber) do
				-- ScoreDisplay doesn't get set to 0 in code
				local score = SCREENMAN:GetTopScreen():GetChild("Score"..ToEnumShortString(pn));
				if score then
					score:settext("        0");
				end;
			end;
		end;
	end;
	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
	CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
};

return t;